*** COS 2020 12, last update 2022 01  
           
program define dq_out_log  
syntax , [ indent(int 0) columncount(int 4)]  
local indent=`indent'+5  
local adoname "dq_out_log"  
local text_i "di as text _n "  					  
tempvar misscount  		  
local vdesc1 	"Data quality overall summary - maximum detected problem"  
local vlist1 	"dqi_varmax*"  
local vmod1  	0  
local vdesc2 	"Data quality overview"  
local vlist2 	"*dqi"  
local vmod2  	0  
local vdesc3 	"Descriptive overview I"  
local vlist3 	"vp_levels* vp_mean* vp_sd* vp_N_*"  
local vmod3  	0  
local vdesc4 	"Descriptive overview II"  
local vlist4 	"vp_min* vp_p50* vp_max* vp_max*"  
local vmod4  	0  
local vdesc5 	"Missing and available cases overview I"  
local vlist5 	"im1_any_PE* im1_sysmis_NU* vp_N_*"  
local vmod5  	0  
local vdesc6 	"Missing and available cases overview II"  
local vlist6 	"im1_jump_NU* im1_jump_PE* im1_any_NU* im1_any_PE*"  
local vmod6  	0  
local vdesc7 	"Inadmissible values"  
local vlist7 	"rv1_hlc* "  
local vmod7  	0  
local vdesc8 	"Uncertain values"  
local vlist8 	"rv1_slc* "  
local vmod8  	0  
local vdesc9 	"Extreme values"  
local vlist9 	"rv1_dlc* "  
local vmod9  	0  
local vdesc10 	"Intraclass correlations for two levels"  
local vlist10 	"icc1_fe*"  
local vmod10  	1  
local vdesc11 	"Intraclass correlations for three levels"  
local vlist11 	"icc2_icc*"  
local vmod11  	1  
local vdesc12 	"Change log for variable modifications during checking of original variables"  
local vmod12  	0  
			        
forvalues n=1/12 {  
	local varlist ""  
	local dqirequest=strpos("`vlist`n''","dqi")														  
	foreach var of local vlist`n' {  
		qui capture ds `var'*  
		if _rc==0 	local varlist="`varlist' `r(varlist)'"											  
		*if `dqirequest'==0 & strpos("`var'","dqi")==0 local varlist="`varlist' `r(varlist)'"		  
	}	        
	local stringnum=0																				  
	tokenize `varlist'  
	while "`1'"~="" {  
		local 	stringnum=`stringnum'+1  
		local varlist`stringnum' ""  
		forvalues o=1/`columncount' {  
			if "`1'"~=""  local varlist`stringnum' "`varlist`stringnum'' `1'"  
			macro shift	  
		}        
	}	        
	forvalues o=1/`stringnum' {																	  
			        
		local varcount=wordcount("`varlist`o''")												  
		qui egen `misscount'=rowmiss(`varlist`o'')	  
		         
		di _n(3)  
		`text_i' "# `vdesc`n''" _n  
		`text_i' "## Variable list `varlist`o''" _n  
		descr `varlist`o'', fullnames  
		list var_name varshortlabel `varlist`o''  if modified==`vmod`n'' & `misscount'<`varcount',  abbreviate(28) header(30) constant separator(10)  
		qui drop `misscount'  
		         
	}         
	          
}          
			        
end        
